/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @DontObfuscate
    public static void main(String[] $$0) {
        aa.a();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$9 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$10 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$14 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$15 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$16 = $$1.nonOptions();
        try {
            void $$44;
            Dynamic $$37;
            OptionSet $$17 = $$1.parse($$0);
            if ($$17.has((OptionSpec)$$9)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$18 = (Path)$$17.valueOf((OptionSpec)$$15);
            if ($$18 != null) {
                Main.a($$18);
            }
            o.h();
            if ($$17.has((OptionSpec)$$14)) {
                bgy.e.a(bgw.b);
            }
            ahi.a();
            ahi.c();
            ac.l();
            Path $$19 = Paths.get("server.properties", new String[0]);
            amc $$20 = new amc($$19);
            $$20.b();
            Path $$21 = Paths.get("eula.txt", new String[0]);
            ahm $$22 = new ahm($$21);
            if ($$17.has((OptionSpec)$$3)) {
                a.info("Initialized '{}' and '{}'", (Object)$$19.toAbsolutePath(), (Object)$$21.toAbsolutePath());
                return;
            }
            if (!$$22.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$23 = new File((String)$$17.valueOf((OptionSpec)$$10));
            ahz $$24 = ahz.a(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$23);
            String $$25 = Optional.ofNullable((String)$$17.valueOf((OptionSpec)$$11)).orElse($$20.a().m);
            egm $$26 = egm.b($$23.toPath());
            egm.c $$27 = $$26.d($$25);
            if ($$27.k()) {
                void $$36;
                try {
                    Dynamic<?> $$28 = $$27.f();
                    egn $$29 = $$27.a($$28);
                }
                catch (IOException | sy | te $$30) {
                    egm.b $$31 = $$27.c();
                    a.warn("Failed to load world data from {}", (Object)$$31.b(), (Object)$$30);
                    a.info("Attempting to use fallback");
                    try {
                        Dynamic<?> $$32 = $$27.g();
                        egn $$33 = $$27.a($$32);
                    }
                    catch (IOException | sy | te $$34) {
                        a.error("Failed to load world data from {}", (Object)$$31.c(), (Object)$$34);
                        a.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)$$31.b(), (Object)$$31.c());
                        return;
                    }
                    $$27.l();
                }
                if ($$36.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$36.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                $$37 = null;
            }
            Dynamic $$38 = $$37;
            boolean $$39 = $$17.has((OptionSpec)$$8);
            if ($$39) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            apt $$40 = apw.a($$27);
            try {
                aib.c $$41 = Main.a($$20.a(), $$38, $$39, $$40);
                aic $$42 = (aic)ac.c(arg_0 -> Main.a($$41, $$38, $$17, (OptionSpec)$$4, $$20, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$43) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$43);
                return;
            }
            iu.b $$45 = $$44.c().a();
            if ($$17.has((OptionSpec)$$6)) {
                Main.a($$27, avx.a(), $$17.has((OptionSpec)$$7), () -> true, $$45.d(ke.aN));
            }
            egs $$46 = $$44.d();
            $$27.a($$45, $$46);
            final ama $$47 = MinecraftServer.a(arg_0 -> Main.a($$27, $$40, (aic)$$44, $$20, $$24, $$17, (OptionSpec)$$12, (OptionSpec)$$4, (OptionSpec)$$13, (OptionSpec)$$2, (OptionSpec)$$16, arg_0));
            Thread $$48 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$47.a(true);
                }
            };
            $$48.setUncaughtExceptionHandler(new r(a));
            Runtime.getRuntime().addShutdownHook($$48);
        }
        catch (Exception $$49) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$49);
        }
    }

    private static void a(Path $$0) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString($$0, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static aib.c a(amb $$0, @Nullable Dynamic<?> $$1, boolean $$2, apt $$3) {
        cuj $$8;
        boolean $$7;
        if ($$1 != null) {
            cuj $$4 = egm.a($$1);
            boolean $$5 = false;
            cuj $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new cuj($$0.T, chu.h);
        }
        aib.d $$9 = new aib.d($$3, $$8, $$2, $$7);
        return new aib.c($$9, dt.a.b, $$0.B);
    }

    private static void a(egm.c $$0, DataFixer $$1, boolean $$2, BooleanSupplier $$3, it<dmr> $$4) {
        a.info("Forcing world upgrade!");
        bjp $$5 = new bjp($$0, $$1, $$4, $$2);
        vf $$6 = null;
        while (!$$5.b()) {
            int $$8;
            vf $$7 = $$5.h();
            if ($$6 != $$7) {
                $$6 = $$7;
                a.info($$5.h().getString());
            }
            if (($$8 = $$5.e()) > 0) {
                int $$9 = $$5.f() + $$5.g();
                a.info("{}% completed ({} / {} chunks)...", new Object[]{auo.d((float)$$9 / (float)$$8 * 100.0f), $$9, $$8});
            }
            if (!$$3.getAsBoolean()) {
                $$5.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ ama a(egm.c $$0, apt $$1, aic $$2, amc $$3, ahz $$4, OptionSet $$5, OptionSpec $$6, OptionSpec $$7, OptionSpec $$8, OptionSpec $$9, OptionSpec $$10, Thread $$11) {
        boolean $$13;
        ama $$12 = new ama($$11, $$0, $$1, $$2, $$3, avx.a(), $$4, ano::new);
        $$12.a((Integer)$$5.valueOf($$6));
        $$12.c($$5.has($$7));
        $$12.b((String)$$5.valueOf($$8));
        boolean bl2 = $$13 = !$$5.has($$9) && !$$5.valuesOf($$10).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.bm();
        }
        return $$12;
    }

    private static /* synthetic */ CompletableFuture a(aib.c $$0, Dynamic $$1, OptionSet $$2, OptionSpec $$3, amc $$4, OptionSpec $$52, Executor $$6) {
        return aib.a($$0, (aib.a $$5) -> {
            dpl $$14;
            dpo $$13;
            ctt $$12;
            it<dmr> $$6 = $$5.d().d(ke.aN);
            if ($$1 != null) {
                egj $$7 = egm.a($$1, $$5.b(), $$6, $$5.c());
                return new aib.b<egs>($$7.a(), $$7.b().b());
            }
            a.info("No existing world data, creating new world");
            if ($$2.has($$3)) {
                ctt $$8 = MinecraftServer.e;
                dpo $$9 = dpo.b;
                dpl $$10 = dyw.a($$5.c());
            } else {
                amb $$11 = $$4.a();
                $$12 = new ctt($$11.m, $$11.l, $$11.u, $$11.k, false, new ctl(), $$5.b());
                $$13 = $$2.has($$52) ? $$11.Y.a(true) : $$11.Y;
                $$14 = $$11.a($$5.c());
            }
            dpl.b $$15 = $$14.a($$6);
            Lifecycle $$16 = $$15.a().add($$5.c().e());
            return new aib.b<egq>(new egq($$12, $$13, $$15.d(), $$16), $$15.b());
        }, aic::new, ac.f(), $$6);
    }
}

